/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import com.mojang.datafixers.util.Either;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class CustomInteractListScreenHandler
extends ServerOnlyScreenHandler<Data> {
    private final Claim claim;
    private final Type type;
    private boolean removeMode;

    private CustomInteractListScreenHandler(int syncId, class_1661 playerInventory, Data data) {
        super(syncId, playerInventory, 6, data);
        this.claim = data.claim;
        this.type = data.type;
    }

    public static void openMenu(class_1657 player, final Type type, final Claim claim) {
        class_3908 fac = new class_3908(){

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new CustomInteractListScreenHandler(syncId, inv, new Data(claim, type));
            }

            public class_2561 method_5476() {
                return ClaimUtils.translatedText(type.translationKey, new Object[0]);
            }
        };
        player.method_17355(fac);
    }

    @Override
    protected void fillInventoryWith(class_1657 player, SeparateInv inv, Data data) {
        for (int i = 0; i < 54; ++i) {
            class_1799 stack;
            if (i == 0) {
                stack = new class_1799((class_1935)class_1802.field_8626);
                stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText("flan.screenBack", class_124.field_1079));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 3) {
                stack = new class_1799((class_1935)class_1802.field_8782);
                stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText("flan.screenAdd", class_124.field_1077));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 4) {
                stack = new class_1799((class_1935)class_1802.field_8793);
                stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), class_124.field_1079));
                inv.updateStack(i, stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            List<class_1799> stacks = switch (data.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> data.claim.allowedItems.asStacks();
                case 1 -> data.claim.allowedBreakBlocks.asStacks();
                case 2 -> data.claim.allowedUseBlocks.asStacks();
                case 3 -> data.claim.allowedEntityAttack.asStacks();
                case 4 -> data.claim.allowedEntityUse.asStacks();
            };
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1;
            if (id >= stacks.size()) continue;
            class_1799 stack2 = stacks.get(id);
            class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack2, tag -> tag.method_10569("Index", id));
            inv.updateStack(i, stack2);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(class_3222 player, int index, class_1735 slot, int clickType) {
        if (index == 0) {
            player.method_7346();
            player.method_5682().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, this.claim));
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.method_7346();
            player.method_5682().execute(() -> StringResultScreenHandler.createNewStringResult((class_1657)player, s -> {
                switch (this.type.ordinal()) {
                    case 0: {
                        if (s.startsWith("#")) {
                            this.claim.allowedItems.addAllowedItem((Either<class_1792, class_6862<class_1792>>)Either.right((Object)class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)class_2960.method_60654((String)s.substring(1)))));
                            break;
                        }
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)s));
                        if (item == class_1802.field_8162) break;
                        this.claim.allowedItems.addAllowedItem((Either<class_1792, class_6862<class_1792>>)Either.left((Object)item));
                        break;
                    }
                    case 1: {
                        if (s.startsWith("#")) {
                            this.claim.allowedBreakBlocks.addAllowedItem((Either<class_2248, class_6862<class_2248>>)Either.right((Object)class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)class_2960.method_60654((String)s.substring(1)))));
                            break;
                        }
                        class_2248 block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)s));
                        if (block == class_2246.field_10124) break;
                        this.claim.allowedBreakBlocks.addAllowedItem((Either<class_2248, class_6862<class_2248>>)Either.left((Object)block));
                        break;
                    }
                    case 2: {
                        if (s.startsWith("#")) {
                            this.claim.allowedUseBlocks.addAllowedItem((Either<class_2248, class_6862<class_2248>>)Either.right((Object)class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)class_2960.method_60654((String)s.substring(1)))));
                            break;
                        }
                        class_2248 block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)s));
                        if (block == class_2246.field_10124) break;
                        this.claim.allowedUseBlocks.addAllowedItem((Either<class_2248, class_6862<class_2248>>)Either.left((Object)block));
                        break;
                    }
                    case 3: {
                        if (s.startsWith("#")) {
                            this.claim.allowedEntityAttack.addAllowedItem(Either.right((Object)class_6862.method_40092((class_5321)class_7923.field_41177.method_30517(), (class_2960)class_2960.method_60654((String)s.substring(1)))));
                            break;
                        }
                        class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(class_2960.method_60654((String)s));
                        if (entityType == class_1299.field_6093 && !s.equals("minecraft:pig")) break;
                        this.claim.allowedEntityAttack.addAllowedItem(Either.left((Object)entityType));
                        break;
                    }
                    case 4: {
                        if (s.startsWith("#")) {
                            this.claim.allowedEntityUse.addAllowedItem(Either.right((Object)class_6862.method_40092((class_5321)class_7923.field_41177.method_30517(), (class_2960)class_2960.method_60654((String)s.substring(1)))));
                            break;
                        }
                        class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(class_2960.method_60654((String)s));
                        if (entityType == class_1299.field_6093 && !s.equals("minecraft:pig")) break;
                        this.claim.allowedEntityUse.addAllowedItem(Either.left((Object)entityType));
                    }
                }
                player.method_7346();
                player.method_5682().execute(() -> CustomInteractListScreenHandler.openMenu((class_1657)player, this.type, this.claim));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_14559, 1.0f, 1.0f);
            }, () -> {
                player.method_7346();
                player.method_5682().execute(() -> CustomInteractListScreenHandler.openMenu((class_1657)player, this.type, this.claim));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            class_1799 stack = new class_1799((class_1935)class_1802.field_8793);
            stack.method_57379(class_9334.field_49631, (Object)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), class_124.field_1079));
            slot.method_7673(stack);
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        class_1799 stack = slot.method_7677();
        if (!stack.method_7960()) {
            int idx;
            class_9279 nbt = (class_9279)stack.method_57824(class_9334.field_49628);
            int n = idx = nbt != null ? nbt.method_57461().method_10550("Index") : 0;
            if (this.removeMode) {
                switch (this.type.ordinal()) {
                    case 0: {
                        this.claim.allowedItems.removeAllowedItem(idx);
                        break;
                    }
                    case 1: {
                        this.claim.allowedBreakBlocks.removeAllowedItem(idx);
                        break;
                    }
                    case 2: {
                        this.claim.allowedUseBlocks.removeAllowedItem(idx);
                    }
                }
                slot.method_7673(class_1799.field_8037);
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_14911, 1.0f, 1.0f);
            }
        }
        return false;
    }

    public record Data(Claim claim, Type type) {
    }

    public static enum Type {
        ITEM("flan.screenMenuItemUse", "item"),
        BLOCKBREAK("flan.screenMenuBlockBreak", "block_break"),
        BLOCKUSE("flan.screenMenuBlockUse", "block_use"),
        ENTITYATTACK("flan.screenMenuEntityAttack", "entity_attack"),
        ENTITYUSE("flan.screenMenuEntityUse", "entity_use");

        public final String translationKey;
        public final String commandKey;

        private Type(String translationKey, String commandKey) {
            this.translationKey = translationKey;
            this.commandKey = commandKey;
        }
    }
}

